using System;
using System.Data;
using System.Data.SqlClient;
using STOREDPROC = gov.va.med.vbecs.Common.VbecsStoredProcs;
using gov.va.med.vbecs.Common;

namespace gov.va.med.vbecs.DAL
{
	#region Header

	///<Package>Package: VBECS - VistA Blood Establishment Computer System</Package>
	///<Warning> 
	///WARNING: Per VHA Directive $VADIRECTIVE this class should not be modified
	///</Warning>
	///<MedicalDevice> Medical Device #: $MEDDEVICENO</MedicalDevice>
	///<Developers>
	///	<Developer>Software Architects, Inc.</Developer>
	///</Developers>
	///<SiteName>Hines OIFO</SiteName>
	///<CreationDate>3/9/2004</CreationDate>
	///<Note>
	///The Food and Drug Administration classifies this software as a medical device.  
	///As such, it may not be changed in any way. Modifications to this software may 
	///result in an adulterated medical device under 21CFR820, the use of which is 
	///considered to be a violation of US Federal Statutes. Acquiring and implementing 
	///this software through the Freedom of information Act requires the implementor 
	///to assume total responsibility for the software, and become a registered 
	///manufacturer of a medical device, subject to FDA regulations
	///</Note>
	///<summary>
	/// Static class implementing a data persistence logic for blood availability.
	/// Retrieves from database BOL.BloodAvailability class data. 
	///</summary>

	#endregion

	public class BloodAvailability
	{
		#region Static Methods
		///<Developers>
		///	<Developer>Margaret Jablonski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>3/9/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="3887"> 
		///		<ExpectedInput>Valid blood availability with division filter set</ExpectedInput>
		///		<ExpectedOutput>Data set containing report data</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="3888"> 
		///		<ExpectedInput>Empty string</ExpectedInput>
		///		<ExpectedOutput>Sql Exception thrown</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// Returns a dataset of blood units and corresponding attributes. 
		/// The data is filtered by the parameters passed in.
		/// </summary>
		/// <param name="parameters"></param>
		/// <returns></returns>
		public static DataSet GetBloodAvailabilityItems( string parameters)
		{
			// Parameters to be passed to the stored proc
			SqlParameter[] par = {
									 // Parameter specifies what to filter the data by.
									 new SqlParameter(STOREDPROC.GetBloodAvailabilityItems.WhereClause, SqlDbType.NVarChar, 4000),
									 new SqlParameter(STOREDPROC.GetBloodAvailabilityItems.divisioncode, SqlDbType.Char, 5)
								 };
			par[0].Value = parameters;
			par[1].Value = Common.LogonUser.LogonUserDivisionCode;
			// Return the data set
			return StoredProcedure.GetData(STOREDPROC.GetBloodAvailabilityItems.StoredProcName, par);
		}


		///<Developers>
		///	<Developer>Margaret Jablonski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>3/9/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="3889"> 
		///		<ExpectedInput>Valid blood availability with division filter set</ExpectedInput>
		///		<ExpectedOutput>Data set containing antigen report data</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="3890"> 
		///		<ExpectedInput>Empty string</ExpectedInput>
		///		<ExpectedOutput>Sql Exception thrown</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// Returns a dataset of antigens that are assigned to blood units. 
		/// The data is filtered by the parameters passed in.
		/// </summary>
		/// <param name="parameters"></param>
		/// <returns></returns>
		public static DataSet GetBloodAvailabilityAntigens( string parameters)
		{
			// Parameters to be passed to the stored proc
			SqlParameter[] par = {
									 // Parameter specifies what to filter the data by.
									new SqlParameter(STOREDPROC.GetBloodAvailabilityAntigens.WhereClause, SqlDbType.NVarChar, 4000)
								 };
			par[0].Value = parameters;
			// Return the data set
			return StoredProcedure.GetData(STOREDPROC.GetBloodAvailabilityAntigens.StoredProcName, par);
		}


		///<Developers>
		///	<Developer>Margaret Jablonski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>3/9/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="3891"> 
		///		<ExpectedInput>Valid blood availability with division filter set</ExpectedInput>
		///		<ExpectedOutput>Data set containing report comment data</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="3892"> 
		///		<ExpectedInput>Empty string</ExpectedInput>
		///		<ExpectedOutput>Sql Exception thrown</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// Returns a dataset populated with comments associated with blood units.
		/// The data returned is filtered based on the parameters passed into 
		/// the method.
		/// </summary>
		/// <param name="parameters"></param>
		/// <returns></returns>
		public static DataSet GetBloodAvailabilityComments( string parameters)
		{
			// Parameters to be passed to the stored proc
			SqlParameter[] par = {			
									 // Parameter specifies what to filter the data by.
									new SqlParameter(STOREDPROC.GetBloodAvailabilityComments.WhereClause, SqlDbType.NVarChar, 4000)
								 };
			par[0].Value = parameters;
			//Return the data set
			return StoredProcedure.GetData(STOREDPROC.GetBloodAvailabilityComments.StoredProcName, par);
		}


		///<Developers>
		///	<Developer>Margaret Jablonski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>3/9/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="3893"> 
		///		<ExpectedInput>Valid blood availability with division filter set</ExpectedInput>
		///		<ExpectedOutput>Data set containing report test comment data</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="3894"> 
		///		<ExpectedInput>Empty string</ExpectedInput>
		///		<ExpectedOutput>Sql Exception thrown</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// This method returns a dataset populated with comments about tests
		/// performed on blood units based on the parameters passed into the
		/// method.
		/// </summary>
		/// <param name="parameters"></param>
		/// <returns></returns>
		public static DataSet GetBloodAvailabilityTestComments(string parameters)
		{
			// Parameters to be passed to the stored proc
			SqlParameter[] par = {
									 // Parameter specifies what to filter the data by.
									new SqlParameter(STOREDPROC.GetBloodAvailabilityTestComments.WhereClause, SqlDbType.NVarChar, 4000)
								 };
			par[0].Value = parameters;
			// Return the data set
			return StoredProcedure.GetData(STOREDPROC.GetBloodAvailabilityTestComments.StoredProcName, par);
		}


		///<Developers>
		///	<Developer>Margaret Jablonski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>3/9/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="3895"> 
		///		<ExpectedInput>Valid blood availability with division filter set</ExpectedInput>
		///		<ExpectedOutput>Count of report items</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="3896"> 
		///		<ExpectedInput>Empty string</ExpectedInput>
		///		<ExpectedOutput>Sql Exception thrown</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// Returns an integer representing the number of rows that would be 
		/// returned from a query based on the parameters passed in. This method
		/// is used to determine whether to alert the user about the possibility
		/// of the report taking a long time to develop and if so allowing the
		/// user to cancel the search.
		/// </summary>
		/// <param name="parameters"></param>
		/// <returns></returns>
		public static int GetBloodAvailabilityCount(string parameters)
		{
			// Parameters to be passed to the stored proc
			SqlParameter[] par = {
									 // Parameter specifies what to filter the data by.
									new SqlParameter(STOREDPROC.GetBloodAvailabilityCount.WhereClause, SqlDbType.NVarChar, 4000)
								 };
			par[0].Value = parameters;
			// Return the data set
			return (int)(StoredProcedure.GetData(STOREDPROC.GetBloodAvailabilityCount.StoredProcName, par).Tables[0].Rows[0]["Total"]);
		}

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>10/6/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="8341"> 
		///		<ExpectedInput>PatientGuid</ExpectedInput>
		///		<ExpectedOutput>int</ExpectedOutput>
		///	</Case>
		///
		///
		///<Case type="1" testid ="8342"> 
		///		<ExpectedInput>Invalid PatientGuid</ExpectedInput>
		///		<ExpectedOutput>zero</ExpectedOutput>
		///	</Case>
		///
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Returns an integer representing the number of rows that would be 
		/// returned from a query based on the parameters passed in. This method
		/// is used to determine whether to alert the user about blood
		/// availability on the patient info toolbar
		/// </summary>
		/// <param name="patientGuid"></param>
		/// <returns></returns>
		public static int GetBloodAvailabilityPatientCount(Guid patientGuid)
		{
			if (patientGuid == Guid.Empty)
			{
				throw new ArgumentNullException("patient guid");
			}
			//
			// Parameters to be passed to the stored proc
			SqlParameter[] par = {
				// Parameter specifies what to filter the data by.
				new SqlParameter(STOREDPROC.GetBloodAvailabilityPatientCount.patientguid, SqlDbType.UniqueIdentifier),
				new SqlParameter(STOREDPROC.GetBloodAvailabilityPatientCount.divisioncode, SqlDbType.Char)
			};
			par[0].Value = patientGuid;
			par[1].Value = Common.LogonUser.LogonUserDivisionCode;
			// Return the count
			return (int)(StoredProcedure.GetData(STOREDPROC.GetBloodAvailabilityPatientCount.StoredProcName, par).Tables[0].Rows[0]["Total"]);
		}

		///<Developers>
		///	<Developer>Margaret Jablonski</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>3/9/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="3897"> 
		///		<ExpectedInput>Valid blood availability with division filter set</ExpectedInput>
		///		<ExpectedOutput>Data set containing report test result data</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="3898"> 
		///		<ExpectedInput>Empty string</ExpectedInput>
		///		<ExpectedOutput>Sql Exception thrown</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// Returns a dataset filled with test results from tests performed
		/// on blood units. The data is filtered by the parameters passed
		/// into the method.
		/// </summary>
		/// <param name="parameters"></param>
		/// <returns></returns>
		public static DataSet GetBloodAvailabilityTestResults(string parameters)
		{
			// Parameters to be passed to the stored proc
			SqlParameter[] par = {
									 // Parameter specifies what to filter the data by.
									new SqlParameter(STOREDPROC.GetBloodAvailabilityTestResults.WhereClause, SqlDbType.NVarChar, 4000)
								 };
			par[0].Value = parameters;
			// Return the data set
			return StoredProcedure.GetData(STOREDPROC.GetBloodAvailabilityTestResults.StoredProcName, par);
		}
		
		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>5/14/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="4391"> 
		///		<ExpectedInput>Valid blood availability with division filter set</ExpectedInput>
		///		<ExpectedOutput>Data set containing report assigned patient data</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="4392"> 
		///		<ExpectedInput>Empty string</ExpectedInput>
		///		<ExpectedOutput>Sql Exception thrown</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		/// <summary>
		/// Returns a dataset filled with assigned patients
		/// of blood units. The data is filtered by the parameters passed
		/// into the method.
		/// </summary>
		/// <param name="parameters"></param>
		/// <returns></returns>
		public static DataSet GetBloodAvailabilityAssignedPatients( string parameters)
		{
			// Parameters to be passed to the stored proc
			SqlParameter[] par = {
									 // Parameter specifies what to filter the data by.
									new SqlParameter(STOREDPROC.GetBloodAvailabilityAssignedPatients.WhereClause, SqlDbType.NVarChar, 4000)
								 };
			par[0].Value = parameters;
			//Return the data set
			return StoredProcedure.GetData(STOREDPROC.GetBloodAvailabilityAssignedPatients.StoredProcName, par);
		}


		///<Developers>
		///	<Developer>Greg Lohse</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>8/8/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="7444"> 
		///		<ExpectedInput>Valid blood availability with division filter set</ExpectedInput>
		///		<ExpectedOutput>Data set containing report modified target unit data</ExpectedOutput>
		///	</Case>
		///
		///
		///<Case type="1" testid ="7445"> 
		///		<ExpectedInput>Empty string</ExpectedInput>
		///		<ExpectedOutput>Sql Exception thrown</ExpectedOutput>
		///	</Case>
		///
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Returns a dataset filled with target units
		/// of blood units. The data is filtered by the parameters passed
		/// into the method.
		/// </summary>
		/// <param name="parameters"></param>
		/// <returns></returns>
		public static DataSet GetBloodAvailabilityTargetUnits( string parameters)
		{
			// Parameters to be passed to the stored proc
			SqlParameter[] par = {
									 // Parameter specifies what to filter the data by.
									new SqlParameter(STOREDPROC.GetBloodAvailabilityTargetUnits.WhereClause, SqlDbType.NVarChar, 4000)
								 };
			par[0].Value = parameters;
			//Return the data set
			return StoredProcedure.GetData(STOREDPROC.GetBloodAvailabilityTargetUnits.StoredProcName, par);
		}
		#endregion
	}
}